<?php
/* fastpaymentbd WHMCS Plugin
 *
 * Copyright (c) 2023 Tup Hoster Ltd
 * Website: https://tuphoster.my.id/
 * Developer: Tup Hoster Ltd
 *
 */

/*
How to use ?

Go to Module of your file - then go to gateway and upload file in root folder
then again upload it on Callback file.

*/


if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function fastpaymentbd_MetaData()
{
    return array(
        'DisplayName' => 'fastpaymentbd',
        'APIVersion' => '1.0',
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}

function fastpaymentbd_config()
{
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'Fatpayment Bd',
        ),
        'apiKey' => array(
            'FriendlyName' => 'API Key',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '',
            'Description' => 'Enter Your Api Key',
        ),

        'currency_rate' => array(
            'FriendlyName' => 'Currency Rate',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '85',
            'Description' => 'Enter Dollar Rate',
        )
    );
}


function fastpaymentbd_link($params)
{
    $host_config = $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    $host_config = pathinfo($host_config, PATHINFO_FILENAME);

    // Get the invoice amount from $params
    $amount = $params['amount'];

    // If the amount is 0 or less, show a message instead of a payment button
    if ($amount <= 0) {
        return '<p class="alert alert-info">This invoice has no outstanding balance.</p>';
    }

    // Check if it's a POST request to initiate payment from viewinvoice page
    if (isset($_POST['pay'])) {
        // Call the payment URL function which handles redirection
        fastpaymentbd_payment_url($params);
        // Since fastpaymentbd_payment_url performs a header redirect and exits,
        // this part of the code should ideally not be reached if successful.
        // If it returns, it means there was an error message from the API call.
        return '<p class="alert alert-danger">Payment initiation failed. Please try again or contact support.</p>';
    }

    // If on viewinvoice.php, show a submit button that will trigger the POST action
    if ($host_config == "viewinvoice") {
        return '<form action="" method="POST">
            <input class="btn btn-primary" name="pay" type="submit" value="' . $params['langpaynow'] . '" />
        </form>';
    } else {
        // For other pages (e.g., checkout process), directly generate the payment URL form
        $response = fastpaymentbd_payment_url($params, false); // Pass false to prevent immediate redirect if not POST
        if ($response && $response->status) {
            return '<form action="' . $response->payment_url . ' " method="GET">
                <input class="btn btn-primary" type="submit" value="' . $params['langpaynow'] . '" />
            </form>';
        }
        return '<p class="alert alert-danger">' . ($response ? $response->message : 'Payment gateway could not be initialized.') . '</p>';
    }
}


function fastpaymentbd_payment_url($params, $redirectImmediately = true)
{
    $cus_name = $params['clientdetails']['firstname'] . " " . $params['clientdetails']['lastname'];
    $cus_email = $params['clientdetails']['email'];

    $apikey = $params['apiKey'];
    // $secretkey = $params['secretKey']; // Not defined in config, so it will be null

    $currency_rate = $params['currency_rate'];

    $invoiceId = $params['invoiceid'];

    $amount = $params['amount'];
    if ($params['currency'] == "USD") {
        $amount = $params['amount'] * $currency_rate;
    }

    // Determine system URL dynamically
    if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
        $systemUrl = "https://";
    } else {
        $systemUrl = "http://";
    }
    $systemUrl .= $_SERVER['HTTP_HOST']; // This gets base domain and port
    // For a robust system URL, WHMCS's own SystemURL setting is preferred
    // global $whmcs;
    // $systemUrl = $whmcs->get_config('SystemURL');
    // If you use $systemUrl = $whmcs->get_config('SystemURL'); then ensure $whmcs is available or get it differently.
    // For simplicity, sticking to $_SERVER for now but be aware of its limitations.


    // Build the webhook URL for the callback file
    // Note: It's better to get the API key from gateway settings in the callback file itself,
    // rather than passing it in the URL, for security.
    // However, if your API requires it this way, keep it.
    // Ensure 'secret' is not passed here if not needed or available.
    $webhook_url = $systemUrl . '/modules/gateways/callback/fastpaymentbd.php?api=' . urlencode($apikey) . '&invoice=' . urlencode($invoiceId);
    $success_url = $systemUrl . '/viewinvoice.php?id=' . urlencode($invoiceId);
    $cancel_url = $systemUrl . '/viewinvoice.php?id=' . urlencode($invoiceId);


    $data   = array(
        "cus_name"          => $cus_name,
        "cus_email"         => $cus_email,
        "amount"            => $amount,
        "webhook_url"       => $webhook_url,
        "success_url"       => $success_url,
        "cancel_url"        => $cancel_url,
    );

    $header   = array(
        "api"               => $apikey,
        "url"               => 'https://pay.fastpaymentbd.com/api/payment/create',
    );


    $headers = array(
        'Content-Type: application/json',
        'API-KEY: ' . $header['api'],
    );
    $url = $header['url'];
    $curl = curl_init();
    $data_json = json_encode($data); // Renamed to avoid conflict with $data array

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30, // Increased timeout for better reliability
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $data_json, // Use the JSON encoded string
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_SSL_VERIFYPEER => true, // Good practice for production
        CURLOPT_VERBOSE => false // Set to true for debugging, false for production
    ));

    $response = curl_exec($curl);
    $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($curl);
    curl_close($curl);

    $res = json_decode($response); // Decode as object for consistent access

    if ($res && $res->status && $res->payment_url) {
        if ($redirectImmediately) {
            header('Location: ' . $res->payment_url);
            exit();
        } else {
            return $res; // Return the object for handling in fastpaymentbd_link
        }
    } else {
        // Handle API errors or cURL errors
        $errorMessage = "Payment initiation failed: ";
        if ($curl_error) {
            $errorMessage .= "cURL Error: " . $curl_error;
        } elseif ($http_status != 200) {
            $errorMessage .= "HTTP Status: " . $http_status . ". Response: " . (is_string($response) ? $response : json_encode($response));
        } elseif ($res && isset($res->message)) {
            $errorMessage .= "API Message: " . $res->message;
        } else {
            $errorMessage .= "Unknown error. Raw response: " . $response;
        }

        // Log the error for debugging
        logModuleCall(
            'Bd Secure Pay',
            'Payment URL Generation',
            array('data' => $data, 'headers' => $headers, 'curl_response' => $response, 'curl_error' => $curl_error, 'http_status' => $http_status),
            $errorMessage
        );

        if ($redirectImmediately) {
            // Echo error and exit if immediate redirect was expected but failed
            die('<p class="alert alert-danger">' . $errorMessage . '</p>');
        } else {
            // Return an object with status false and message for fastpaymentbd_link to handle
            return (object)['status' => false, 'message' => $errorMessage];
        }
    }
}